package com.ejie.p06b.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.ejie.p06b.datatype.model.P06B35T00Datatype;
import com.ejie.p06b.general.P06BTablas;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.util.bd.P06BServidorConexionesBD;

/**
 * Fecha de creacin: (05/07/2010)
 */
public class P06B35T00DAO {
	
	static private P06B35T00DAO instance = null;

	public static P06B35T00DAO getInstance() {
	     if (instance == null) {
	          synchronized (P06B35T00DAO.class) {
	          		if (instance == null) {
	                     instance = new P06B35T00DAO();
	                }
	          }
	     }
	     return instance;
	}
	
	
	/**
    * Obtiene un registro de la BD a partir de la clave primaria
    * @param numExp.
    *            parte de la clave primaria
    * @param ejer.
    *            parte de la clave primaria
    * @return un objeto P06B35T00Datatype o null si no se encuentra nada.
	* @throws Exception
    */
	public P06B35T00Datatype select(String ejer, String numExp) throws Exception{
		P06BLog.send(2,this, "Inicio P06B35T00DAO-select");
		P06B35T00Datatype result = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECT_BY_PK;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,ejer.toUpperCase());
        	lstm.setString(2,numExp.toUpperCase());
        	lrst = lstm.executeQuery();
	        if (lrst.next()) {
	        	result = new P06B35T00Datatype();
	        	
	        	result.setEjercicio(lrst.getString(P06BTablas.P06B_P06B35_EJERCICIO));
	        	result.setNumExp(lrst.getString(P06BTablas.P06B_P06B35_NUMEXP));
				result.setRegSede(lrst.getString(P06BTablas.P06B_P06B35_REGSEDE)==null?"":lrst.getString(P06BTablas.P06B_P06B35_REGSEDE));
				result.setNumEmplSede(lrst.getString(P06BTablas.P06B_P06B35_NUMEMPLSEDE)==null?"":lrst.getString(P06BTablas.P06B_P06B35_NUMEMPLSEDE));
				result.setNumSucur(lrst.getString(P06BTablas.P06B_P06B35_NUMSUCUR)==null?"":lrst.getString(P06BTablas.P06B_P06B35_NUMSUCUR));
				result.setNumEmplSucur(lrst.getString(P06BTablas.P06B_P06B35_NUMEMPLSUCUR)==null?"":lrst.getString(P06BTablas.P06B_P06B35_NUMEMPLSUCUR));
				result.setPrimasSucur(lrst.getString(P06BTablas.P06B_P06B35_PRIMASSUCUR)==null?"":lrst.getString(P06BTablas.P06B_P06B35_PRIMASSUCUR));
					
	        }
	        P06BLog.send(2,this, "Fin P06B35T00DAO-select");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e;
	    }catch (Exception e2) {	 
        	P06BLog.send(2,this, "error: " +e2.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e2;
	    }finally {
	    	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	    }
		return result;
	}
	

	private static String SELECT_BY_PK =	
		"SELECT " +	
		P06BTablas.P06B_P06B35_EJERCICIO + ", " + 
		P06BTablas.P06B_P06B35_NUMEXP + ", " + 
		P06BTablas.P06B_P06B35_REGSEDE + ", " + 
		P06BTablas.P06B_P06B35_NUMEMPLSEDE + ", " + 
		P06BTablas.P06B_P06B35_NUMSUCUR + ", " + 
		P06BTablas.P06B_P06B35_NUMEMPLSUCUR + ", " + 
		P06BTablas.P06B_P06B35_PRIMASSUCUR +
		" FROM "+ P06BTablas.P06B_P06B35T00_TABLA +
		" WHERE " + P06BTablas.P06B_P06B35_EJERCICIO + " = ? and " + P06BTablas.P06B_P06B35_NUMEXP + " = ?";
	
}
